/*
-- Program : NOME
-- Author : Nguoc Tran Nguyen
-- Email : nome-feedback@lexum.umontreal.ca
-- Creation date : 2005-11-07

Copyright (C) 2005 LexUM, RALI - Universit de Montral

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details. http://www.gnu.org/copyleft/gpl.html

You should have received a copy of the GNU General Public License along with this program;
if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/ 

// ColorButton.cpp : implementation file
//

#include "stdafx.h"
#include "nome.h"
#include "ColorButton.h"


// CColorButton

IMPLEMENT_DYNAMIC(CColorButton, CButton)
CColorButton::CColorButton()
{
	m_BkColor = GetSysColor(COLOR_BTNFACE);
	m_TextColor = GetSysColor(COLOR_BTNTEXT);
}

CColorButton::~CColorButton()
{
}


BEGIN_MESSAGE_MAP(CColorButton, CButton)
END_MESSAGE_MAP()



// CColorButton message handlers

void CColorButton::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
   UINT uStyle = DFCS_BUTTONPUSH;

   // This code only works with buttons.
   ASSERT(lpDrawItemStruct->CtlType == ODT_BUTTON);

   // If drawing selected, add the pushed style to DrawFrameControl.
   if (lpDrawItemStruct->itemState & ODS_SELECTED)
      uStyle |= DFCS_PUSHED;

   // Draw the button frame.
   ::DrawFrameControl(lpDrawItemStruct->hDC, &lpDrawItemStruct->rcItem, 
      DFC_BUTTON, uStyle);

    CClientDC dc(this);
    CRect rect;
	GetClientRect(&rect);
	rect.DeflateRect(2,2);
	dc.FillSolidRect(&rect,	m_BkColor);
	
   // Get the button's text.
   CString strText;
   GetWindowText(strText);

   // Draw the button text using the text color red.
	int oldmode = ::SetBkMode(lpDrawItemStruct->hDC, TRANSPARENT);
   COLORREF crOldColor = ::SetTextColor(lpDrawItemStruct->hDC, m_TextColor);
   ::DrawText(lpDrawItemStruct->hDC, strText, strText.GetLength(), 
      &lpDrawItemStruct->rcItem, DT_SINGLELINE|DT_VCENTER|DT_CENTER);
	::SetTextColor(lpDrawItemStruct->hDC, crOldColor);
	::SetBkMode(lpDrawItemStruct->hDC, oldmode);
}
void CColorButton::SetBkColor(COLORREF color)
{
	m_BkColor = color;
	Invalidate(FALSE);
}
void CColorButton::SetTextColor(COLORREF color)
{
	m_TextColor = color;
	Invalidate(FALSE);
}