/*
-- Program : NOME
-- Author : Nguoc Tran Nguyen
-- Email : nome-feedback@lexum.umontreal.ca
-- Creation date : 2005-11-07

Copyright (C) 2005 LexUM, RALI - Universit de Montral

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details. http://www.gnu.org/copyleft/gpl.html

You should have received a copy of the GNU General Public License along with this program;
if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/ 

// NomeTab.cpp : fichier d'implmentation
//

#include "stdafx.h"
#include "nome.h"
#include "NomeTab.h"
#include ".\nometab.h"
#include "TabDlg.h"


// CNomeTab

IMPLEMENT_DYNAMIC(CNomeTab, CTabCtrl)
CNomeTab::CNomeTab()
{
	 pCurrent = NULL;
}

CNomeTab::~CNomeTab()
{	
}


BEGIN_MESSAGE_MAP(CNomeTab, CTabCtrl)
	ON_NOTIFY_REFLECT(TCN_SELCHANGE, OnTcnSelchange)
END_MESSAGE_MAP()



// Gestionnaires de messages CNomeTab

void CNomeTab::activateTab()
{	
   if (m_hWnd == NULL) return;
   int nSel = GetCurSel();
   if (nSel < 0) return;
   if (pCurrent != NULL) pCurrent->ShowWindow(SW_HIDE);
   if (dlgs.GetSize()== 0) return;
   pCurrent = dlgs.GetAt(nSel);
   if (pCurrent == NULL) return;
   pCurrent->ShowWindow(SW_SHOW);   
   CRect l_rectClient;
   CRect l_rectWnd;

   GetClientRect(l_rectClient);
   AdjustRect(FALSE,l_rectClient);
   GetWindowRect(l_rectWnd);
   GetParent()->ScreenToClient(l_rectWnd);
   l_rectClient.OffsetRect(l_rectWnd.left,l_rectWnd.top);
   pCurrent->SetWindowPos(&wndTop, l_rectClient.left, l_rectClient.top, l_rectClient.Width(), l_rectClient.Height(), SWP_SHOWWINDOW);
   CTabDlg *pTab = (CTabDlg*)pCurrent;
   pTab->initTab();
}

void CNomeTab::addDialog(CDialog* pDlg)
{	
	dlgs.Add(pDlg);
	CString str;
	pDlg->GetWindowText(str);
	InsertItem(dlgs.GetSize() - 1,str);
}
void CNomeTab::changeLang(int lang)
{
	TCITEM item;
	item.mask = TCIF_TEXT;
	TCHAR buffer[1000];
	HINSTANCE hInstance = (HINSTANCE) GetModuleHandle ("nome.dll");
	LoadString(hInstance, IDS_REPLACEMENT_EN + lang, buffer, 1000);
	item.pszText = buffer;
	SetItem(0, &item);

	
	LoadString(hInstance, IDS_SETTING_EN + lang, buffer, 1000);
	item.pszText = buffer;
	SetItem(1, &item);
}
void CNomeTab::OnTcnSelchange(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO : ajoutez ici le code de votre gestionnaire 
	// de notification de contrle
	activateTab();
	*pResult = 0;
}