/*
-- Program : NOME
-- Author : Nguoc Tran Nguyen
-- Email : nome-feedback@lexum.umontreal.ca
-- Creation date : 2005-11-07

Copyright (C) 2005 LexUM, RALI - Universit de Montral

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details. http://www.gnu.org/copyleft/gpl.html

You should have received a copy of the GNU General Public License along with this program;
if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/ 

#pragma once
#include "NomeTab.h"
#include "Setting.h"
#include "Replacement.h"
#include "ProgressNome.h"

// Bote de dialogue CNomeTabDlg

class CNomeTabDlg : public CDialog
{
	DECLARE_DYNAMIC(CNomeTabDlg)

public:
	CNomeTabDlg(CWnd* pParent = NULL);   // constructeur standard
	virtual ~CNomeTabDlg();

// Donnes de bote de dialogue
	enum { IDD = IDD_NOME };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);// Prise en charge DDX/DDV

	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnTcnSelchangeTabNome(NMHDR *pNMHDR, LRESULT *pResult);
	BOOL OnInitDialog();
	CNomeTab m_Tab;
	CReplacement m_Replacement;
	CSetting m_Setting;
	CNomeProgress m_Progress;
	int lang,repLang;

	void changeLang(int);
	void changeRepLang(int);
	HWND id;//used to identify an NomeDocument in VBA
	int myID;//id in dialog array
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void On(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnClose();
	afx_msg void OnMove(int x, int y);
	//These functions support C interface for VBA
	int addRow(int nCounts, LPTSTR words, LPTSTR replacement, int type);
	int invokeNome(int msg, int param1 = 0);
	
	SAFEARRAY* getSelectedNamesKeys(BOOLEAN deleted);
	SAFEARRAY* getSelectedNamesPos(int type, BOOLEAN deleted);
	void deleteSelectedRows();
	int findName(LPTSTR name, int col);
	int setProgressPos(LPTSTR status,int pos);
	int getAutoSize();

	BOOL isNameChecked(int);
};