/*
-- Program : NOME
-- Author : Nguoc Tran Nguyen
-- Email : nome-feedback@lexum.umontreal.ca
-- Creation date : 2005-11-07

Copyright (C) 2005 LexUM, RALI - Universit de Montral

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details. http://www.gnu.org/copyleft/gpl.html

You should have received a copy of the GNU General Public License along with this program;
if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/ 

#pragma once
#include "afxwin.h"
#include "colorbox.h"
#include "TabDlg.h"


// Bote de dialogue CSetting

class CSetting : public CTabDlg
{
	DECLARE_DYNAMIC(CSetting)	
public:
	CSetting(CWnd* pParent = NULL);   // constructeur standard
	virtual ~CSetting();
	CString hStyle;
	CString vStyle;
	// Donnes de bote de dialogue
	enum { IDD = IDD_SETTING };
	
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // Prise en charge DDX/DDV
	DECLARE_MESSAGE_MAP()
public:
	void initTab();
	afx_msg void OnBnClickedInclusion();
	afx_msg void OnBnClickedExclusion();
	afx_msg void OnBnClickedTitle();
	afx_msg void OnBnClickedCancel();
	afx_msg void OnBnClickedApply();	
	void reduceString(CString &str, TCHAR* buffer);
	SAFEARRAY* getParameters();
	SAFEARRAY* getTextColors();
	int setParameters( LPCTSTR incl, LPCTSTR excl, LPCTSTR title);
	int setParameterStyles(SAFEARRAY** styles);
	int setTextColors(int normal, int included, 
					   int manual, int same);

	CButton m_inclusion;
	CButton m_exclusion;
	CButton m_title;

	CString strIncl,strExcl,strTitle;
	CString tempIncl,tempExcl,tempTitle;
	afx_msg void OnBnClickedInclusionColor();
	afx_msg void OnBnClickedManualColor();
	void changeLang(int);
	void changeRepLang(int);

	CColorBox m_IncColor, m_ManualColor, m_NormalColor, m_SameColor;
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnBnClickedNormalColor();
	afx_msg void OnBnClickedRenglish();
	afx_msg void OnBnClickedRfrench();
	afx_msg void OnBnClickedReset();
	afx_msg void OnBnClickedSavestyle();
	afx_msg void OnBnClickedRrepfrench();
	afx_msg void OnBnClickedRrepenglish();
	afx_msg void OnBnClickedSameColor();
};
