/*
-- Program : NOME
-- Author : Nguoc Tran Nguyen
-- Email : nome-feedback@lexum.umontreal.ca
-- Creation date : 2005-11-07

Copyright (C) 2005 LexUM, RALI - Universit de Montral

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details. http://www.gnu.org/copyleft/gpl.html

You should have received a copy of the GNU General Public License along with this program;
if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/ 

// NomeDialog.cpp : fichier d'implmentation

#include "stdafx.h"
#include "nome.h"
#include "Replacement.h"
#include "NewCellTypes/GridCellCheck.h"
#include "NewCellTypes/GridCellCombo.h"
#include ".\replacement.h"
#include "MyGrid.h"
#include "NomeTabDlg.h"
#include "afxstr.h"
#include "atlimage.h"
#include "GridCellNome.h"
// Bote de dialogue CNomeDialog
extern GETCOLOR getColor;

static COLORREF colorIndex[]={
		0xFF000000,
		0x00000000,
		0x00FF0000,
		0x00FFFF00,
		0x0000FF00,
		0x00FF00FF,
		0x000000FF,
		0x0000FFFF,
		0x00FFFFFF,
		0x00800000,
		0x00808000,
		0x00008000,
		0x00800080,
		0x00000080,
		0x00008080,
		0x00C0C0C0,
		0x00808080,
		GetSysColor(COLOR_BTNTEXT),
		GetSysColor(COLOR_BTNTEXT)		
	};

static int CALLBACK pfnCellCompare(LPARAM lParam1,
                                            LPARAM lParam2, 
                                            LPARAM lParamSort)
{

	CGridCellBase* pCell1 = (CGridCellBase*) lParam1;
	CGridCellBase* pCell2 = (CGridCellBase*) lParam2;
	if (!pCell1 || !pCell2) return 0;
	if (pCell1->IsKindOf(RUNTIME_CLASS(CGridCellCheck))&&
		pCell2->IsKindOf(RUNTIME_CLASS(CGridCellCheck))){		

		int nValue1 = ((CGridCellCheck*)pCell1)->GetCheck()? 1:0;
		int nValue2 = ((CGridCellCheck*)pCell2)->GetCheck()? 1:0;

		if (nValue1 < nValue2)
			return -1;
		else if (nValue1 == nValue2)
			return 0;
		else
			return 1;
	}
	else{
		int nValue1 = _ttol(pCell1->GetText()); 
		int nValue2 = _ttol(pCell2->GetText()); 
		if ((nValue1 == 0)||(nValue2 == 0))
			return CGridCtrl::pfnCellTextCompare(lParam1, lParam2, lParamSort);
		else{
			if (nValue1 < nValue2)
				return -1;
			else if (nValue1 == nValue2)
				return 0;
			else
				return 1;
		}
	}
}

IMPLEMENT_DYNAMIC(CReplacement, CTabDlg)

CReplacement::CReplacement(CWnd* pParent /*=NULL*/)
	: CTabDlg(CReplacement::IDD, pParent)
{
	rowCombo = -1;
}
CReplacement::~CReplacement()
{
}
void CReplacement::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_GRID, m_Grid);
	DDX_Control(pDX, IDC_BANALYSE, m_Analyse);
	DDX_Control(pDX, IDC_BHIGHLIGHT, m_Highlight);
	DDX_Control(pDX, IDC_BREPLACE, m_Replace);

	DDX_Control(pDX, IDC_BACCEPTM, m_AcceptM);
	DDX_Control(pDX, IDC_BREMOVEM, m_RemoveM);
	DDX_Control(pDX, IDC_BCONFLICT, m_Conflict);

	DDX_Control(pDX, IDC_BADD, m_Plus);
	DDX_Control(pDX, IDC_BREMOVE, m_Minus);
	DDX_Control(pDX, IDC_BPREVIOUS, m_Previous);
	DDX_Control(pDX, IDC_BNEXT, m_Next);
	DDX_Control(pDX, IDC_BDOCK, m_Dock);
}

BEGIN_MESSAGE_MAP(CReplacement, CDialog)
//	ON_WM_SIZE()
ON_WM_SIZE()
ON_BN_CLICKED(IDC_BANALYSE, OnBnClickedBanalyse)
ON_BN_CLICKED(IDC_BREPLACE, OnBnClickedBreplace)
ON_BN_CLICKED(IDC_BHIGHLIGHT, OnBnClickedBhighlight)
ON_BN_CLICKED(IDC_BREMOVE, OnBnClickedBremove)
ON_NOTIFY(GVN_SELCHANGED, IDC_GRID, OnGridEndSelChange)
ON_NOTIFY(NM_CLICK, IDC_GRID, OnGridClick)
ON_NOTIFY(GVN_ENDLABELEDIT, IDC_GRID, OnGridEndEdit)
ON_NOTIFY(GVN_BEGINLABELEDIT, IDC_GRID, OnGridStartEdit)
//ON_NOTIFY(NOMEBUTTON_TOOLTIP, IDC_BANALYSE , OnNBTooltip)
ON_NOTIFY_EX_RANGE(NOMEBUTTON_TOOLTIP, 0,0xFFFF, OnNBTooltip)
//ON_NOTIFY_EX_RANGE(TTN_NEEDTEXTW, 0, 0xFFFF, OnToolTipNotify)

ON_BN_CLICKED(IDC_BPREVIOUS, OnBnClickedBprevious)
ON_BN_CLICKED(IDC_BNEXT, OnBnClickedBnext)
ON_BN_CLICKED(IDC_BADD, OnBnClickedBadd)
ON_BN_CLICKED(IDC_BDOCK, OnBnClickedBdock)
ON_BN_CLICKED(IDC_BCONFLICT, OnBnClickedBconflict)
ON_BN_CLICKED(IDC_BREMOVEM, OnBnClickedBremovem)
ON_BN_CLICKED(IDC_BACCEPTM, OnBnClickedAcceptm)
ON_WM_LBUTTONDOWN()
END_MESSAGE_MAP()

// Gestionnaires de messages CNomeDialog
BOOL CReplacement::PreTranslateMessage(MSG* pMsg)
{
	   return CTabDlg::PreTranslateMessage(pMsg);
}
BOOL CReplacement::OnInitDialog()
{
	CTabDlg::OnInitDialog();
	//load icon image for buttons
	((CNomeButton*)GetDlgItem(IDC_BREPLACE))->SetImage(IDB_R, RGB(255,255,255));
	((CNomeButton*)GetDlgItem(IDC_BREPLACE))->SetTooltipId(IDS_BUTTON_REPLACE_EN);

	((CNomeButton*)GetDlgItem(IDC_BREMOVEM))->SetImage(IDB_RM, RGB(255,255,255));
	((CNomeButton*)GetDlgItem(IDC_BREMOVEM))->SetTooltipId(IDS_BUTTON_REMOVEM_EN);

	((CNomeButton*)GetDlgItem(IDC_BADD))->SetImage(IDB_PLUS, RGB(255,255,255));
	((CNomeButton*)GetDlgItem(IDC_BADD))->SetTooltipId(IDS_BUTTON_ADD_EN);

	((CNomeButton*)GetDlgItem(IDC_BREMOVE))->SetImage(IDB_MINUS, RGB(255,255,255));	
	((CNomeButton*)GetDlgItem(IDC_BREMOVE))->SetTooltipId(IDS_BUTTON_REMOVE_EN);

	((CNomeButton*)GetDlgItem(IDC_BACCEPTM))->SetImage(IDB_AM, RGB(255,255,255));	
	((CNomeButton*)GetDlgItem(IDC_BACCEPTM))->SetTooltipId(IDS_BUTTON_ACCEPTM_EN);

	((CNomeButton*)GetDlgItem(IDC_BNEXT))->SetImage(IDB_NEXT, RGB(255,255,255));
	((CNomeButton*)GetDlgItem(IDC_BNEXT))->SetTooltipId(IDS_BUTTON_NEXT_EN);

	((CNomeButton*)GetDlgItem(IDC_BPREVIOUS))->SetImage(IDB_PREVIOUS, RGB(255,255,255));
	((CNomeButton*)GetDlgItem(IDC_BPREVIOUS))->SetTooltipId(IDS_BUTTON_PREVIOUS_EN);

    ((CNomeButton*)GetDlgItem(IDC_BANALYSE))->SetImage(IDB_A, RGB(255,255,255));
	((CNomeButton*)GetDlgItem(IDC_BANALYSE))->SetTooltipId(IDS_BUTTON_ANALYSE_EN);

	((CNomeButton*)GetDlgItem(IDC_BHIGHLIGHT))->SetType(1);
    ((CNomeButton*)GetDlgItem(IDC_BHIGHLIGHT))->SetImage(IDB_H, RGB(255,255,255));
	((CNomeButton*)GetDlgItem(IDC_BHIGHLIGHT))->SetTooltipId(IDS_BUTTON_HIGHLIGHT_EN);

	((CNomeButton*)GetDlgItem(IDC_BDOCK))->SetImage(IDB_DOCK, RGB(255,255,255));
	((CNomeButton*)GetDlgItem(IDC_BDOCK))->SetTooltipId(IDS_BUTTON_DOCK_EN);

	m_Grid.SetFixedColumnCount(0);
	m_Grid.SetFixedRowCount(1);
	m_Grid.SetColumnCount(5);
	m_Grid.SetItemText(0,0,"Occs");
	/*RECT rect;
	m_Grid.GetCellRect(0, 0, &rect);	
	if (imageList.GetSafeHandle() == NULL){
		imageList.Create(MAKEINTRESOURCE(IDB_GRID),15,1, RGB(255,255,255));
		m_Grid.SetImageList(&imageList);
	}
	m_Grid.SetItemImage(0,1,0);
	m_Grid.SetItemImage(0,2,1);
	*/
	m_Grid.SetItemText(0,1,"-");
	m_Grid.SetItemText(0,2,"R");
	m_Grid.SetItemText(0,3,"Words"); 
	m_Grid.SetItemText(0,4,"Replacements");
	m_Grid.SetHeaderSort(true);
	m_Grid.SetCompareFunction(pfnCellCompare); 
	//m_Grid.SetListMode();	
	m_Grid.AutoSizeColumn(0,GVS_BOTH,true); 
	m_Grid.AutoSizeColumn(1,GVS_BOTH,true); 
	m_Grid.AutoSizeColumn(2,GVS_BOTH,true); 
	m_Grid.AutoSizeColumn(3,GVS_BOTH,true); 
	m_Grid.AutoSizeColumn(4,GVS_BOTH,true); 

	typeColor[ntNormal] = m_Grid.GetTextColor();
	typeColor[ntIncluded] = RGB(255,0,0);
	typeColor[ntManual] = RGB(0,0,255);
	typeColor[ntSame] = RGB(255,128,0);

	m_TitleTip.SetParentWnd(this);
//	resizeDock();
	return TRUE;  // return TRUE unless you set the focus to a control
}
// GVN_ENDLABELEDIT
// GVN_BEGINLABELEDIT

void CReplacement::OnGridStartEdit(NMHDR *pNotifyStruct, LRESULT* pResult)
{
    NM_GRIDVIEW* pItem = (NM_GRIDVIEW*) pNotifyStruct;
	*pResult = 0;
}

void CReplacement::OnGridEndEdit(NMHDR *pNotifyStruct, LRESULT* pResult)
{
    NM_GRIDVIEW* pItem = (NM_GRIDVIEW*) pNotifyStruct;
	*pResult = 0;
	if (pItem->iColumn == 4){
		updateSameReplacement();
	}
	if (pItem->iColumn == 3){
		*pResult = -1;
		return;
	}
}
BOOL CReplacement::updateSameReplacement()
{
	BOOL ret = false;
	reps.RemoveAll();
	int n = m_Grid.GetRowCount();
	for(int index =1; index < n; index++){
		CString temp = m_Grid.GetItemText(index, 4);
		//... is transformed to 133 
		char special[2];
		special[0]=133;
		special[1]='\0';
		temp.Replace("...", special);
		m_Grid.SetItemText(index, 4, temp.GetBuffer());
		if (!ret) ret = selectSameRep(index, temp);
		else selectSameRep(index, temp);
	}
	m_Grid.RedrawColumn(4); 
	return ret;
}
int CReplacement::addRow(int nCount, LPTSTR words, LPTSTR replacement,int type)
{
	CString str;
    str.Format(_T("%d"), nCount);
	int nRows = m_Grid.GetRowCount();
	m_Grid.SetRowCount(m_Grid.GetRowCount() + 1);	
/*	m_Grid.SetCellType(nRows,0,RUNTIME_CLASS(CGridCellCombo));
	CGridCellCombo* pCheckCell = (CGridCellCombo*)m_Grid.GetCell(nRows,0);
	CStringArray options;
	options.Add(_T("R"));
	options.Add(_T("-"));
	options.Add(str);
	pCheckCell->SetOptions(options);*/

//	m_Grid.SetCellType(nRows,0,RUNTIME_CLASS(CGridCellCheck));
//	CGridCellCheck* pCheckCell = (CGridCellCheck*)m_Grid.GetCell(nRows,0);
//	pCheckCell->SetCheck(false);
//	m_Grid.SetItemState(nRows,0, GVIS_READONLY);
//	m_Grid.SetItemState(nRows,1, GVIS_READONLY);

	m_Grid.SetItemText(nRows,0,str);
	m_Grid.SetItemState(nRows,0, GVIS_READONLY);

	m_Grid.SetCellType(nRows,1,RUNTIME_CLASS(CGridCellCheck));
	CGridCellCheck* pCheckCell = (CGridCellCheck*)m_Grid.GetCell(nRows,1);
	pCheckCell->SetCheck(false);
	pCheckCell->SetMargin(0);
	m_Grid.SetCellType(nRows,2,RUNTIME_CLASS(CGridCellCheck));
	pCheckCell = (CGridCellCheck*)m_Grid.GetCell(nRows,2);
	pCheckCell->SetCheck(false);
	pCheckCell->SetMargin(0);

    m_Grid.SetCellType(nRows,3,RUNTIME_CLASS(CGridCellNome));
	m_Grid.SetItemText(nRows,3,words);
	m_Grid.SetItemText(nRows,4,replacement);	
	m_Grid.SetItemFgColour(nRows,0, typeColor[type]);
	m_Grid.SetItemFgColour(nRows,1, typeColor[type]);
	m_Grid.SetItemFgColour(nRows,2, typeColor[type]);
	m_Grid.SetItemFgColour(nRows,3, typeColor[type]);
	m_Grid.SetItemFgColour(nRows,4, typeColor[type]);

	m_Grid.AutoSizeColumn(0,GVS_BOTH,true);
	m_Grid.AutoSizeColumn(1,GVS_BOTH,true); 
	m_Grid.AutoSizeColumn(2,GVS_BOTH,true);
	m_Grid.AutoSizeColumn(3,GVS_BOTH,true);
	m_Grid.AutoSizeColumn(4,GVS_BOTH,true);

	selectSameRep(nRows, replacement);
	
	m_Checked = true;
	return 0;
}
BOOL CReplacement::selectSameRep(int nRows, CString str)
{
	int index = 0;
	if (reps.Lookup(str, index)){
		m_Grid.SetItemBkColour(index,4, typeColor[ntSame]);
		m_Grid.SetItemBkColour(nRows,4, typeColor[ntSame]);
		return true;
	}
	else{
		m_Grid.SetItemBkColour(nRows,4, m_Grid.GetItemBkColour(nRows,0));
		reps.SetAt(str,nRows);
		return false;
	}
}
BOOL CReplacement::selectSameRep(int nRows, LPTSTR rep)
{
	CString str;
	str.SetString(rep);
	return selectSameRep(nRows, str);
}
int CReplacement::selectRowByIndex(int row)
{
	//	m_Grid.SetSelectedRange(1,0,m_Grid.GetRowCount(),4,true,false);	
	m_Grid.SetSelectedRange(row,0,row,4,true);
	return 0;
}
int CReplacement::setRowColor(int row, int type)
{
	m_Grid.SetItemFgColour(row, 0, typeColor[type]);
	m_Grid.SetItemFgColour(row, 1, typeColor[type]);
	m_Grid.SetItemFgColour(row, 2, typeColor[type]);
	m_Grid.SetItemFgColour(row, 3, typeColor[type]);
	m_Grid.SetItemFgColour(row, 4, typeColor[type]);
	return 0;
}
void CReplacement::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);
	
	if (cx <= 1 || cy <= 1 ) 
        return;
	RECT rectGrid;
	if (m_Grid.m_hWnd != NULL){		
		m_Grid.GetWindowRect(&rectGrid);
		m_Grid.GetParent()->ScreenToClient(&rectGrid);
		m_Grid.MoveWindow(rectGrid.left, rectGrid.top, cx, cy - rectGrid.top, true);
	}
	if (m_Dock.m_hWnd != NULL){
		resizeDock();
	}
}
void CReplacement::resizeDock()
{
	RECT rectGrid;
	m_Grid.GetWindowRect(&rectGrid);
	m_Grid.GetParent()->ScreenToClient(&rectGrid);
	RECT rect;
	m_Dock.GetWindowRect(&rect);
	m_Dock.GetParent()->ScreenToClient(&rect);				
	m_Dock.MoveWindow(rectGrid.right - rectGrid.left - rect.right + rect.left , rect.top, rect.right - rect.left , rect.bottom - rect.top, true);

}
int CReplacement::removeAllRows()
{
	if (m_Grid.m_hWnd != NULL)
		m_Grid.DeleteNonFixedRows();
	return 0;
}
void CReplacement::OnBnClickedBanalyse()
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)GetParent();
	reps.RemoveAll();
	pDlg->invokeNome(NOME_ANALYZE); 
	m_TitleTip.SetEnabled(true); 
	// TODO: Add your control notification handler code here
}

void CReplacement::OnBnClickedBreplace()
{
	// TODO: Add your control notification handler code here
	CNomeTabDlg* pDlg = (CNomeTabDlg*)GetParent();
	pDlg->invokeNome(NOME_REPLACE);
	m_TitleTip.SetEnabled(true); 
}

void CReplacement::OnBnClickedBhighlight()
{
	// TODO: Add your control notification handler code here
	CNomeTabDlg* pDlg = (CNomeTabDlg*)GetParent();
	if (getColor != NULL){
		m_Highlight.SetUnderColor(colorIndex[getColor(pDlg->id, 0)]);
	}	
	pDlg->invokeNome(NOME_HIGHLIGHT);	
/*	if (pDlg->invokeNome(NOME_HIGHLIGHT)&&(getColor != NULL)){
		m_Highlight.SetBkColor(colorIndex[getColor(pDlg->id, 0)]);
	}
	else{
		m_Highlight.SetBkColor(GetSysColor(COLOR_BTNFACE));
	}*/
	m_TitleTip.SetEnabled(true); 
}

void CReplacement::OnBnClickedBremove()
{
	// TODO: Add your control notification handler code here
	CNomeTabDlg* pDlg = (CNomeTabDlg*)GetParent();
	pDlg->invokeNome(NOME_REMOVE);
	updateSameReplacement();
	m_TitleTip.SetEnabled(true); 
}

void CReplacement::OnGridEndSelChange(NMHDR *pNotifyStruct, LRESULT* pResult)
{
    NM_GRIDVIEW* pItem = (NM_GRIDVIEW*) pNotifyStruct;	
}

void CReplacement::OnGridClick(NMHDR *pNotifyStruct, LRESULT* pResult)
{
    NM_GRIDVIEW* pItem = (NM_GRIDVIEW*) pNotifyStruct;
	if ((pItem->iColumn == 1)||(pItem->iColumn == 2)){
		CGridCellCheck* pCheckCell = (CGridCellCheck*)m_Grid.GetCell(pItem->iRow, pItem->iColumn);
		if (pCheckCell->GetCheck()){
			pCheckCell = (CGridCellCheck*)m_Grid.GetCell(pItem->iRow, (pItem->iColumn == 1)? 2:1);
			pCheckCell->SetCheck(false);
		}
	}	
	*pResult = 0;
}

void CReplacement::OnBnClickedBprevious()
{
	// TODO: Add your control notification handler code here
	CNomeTabDlg* pDlg = (CNomeTabDlg*)GetParent();
	pDlg->invokeNome(NOME_PREVIOUS);
	m_TitleTip.SetEnabled(true); 
}
void CReplacement::OnBnClickedBnext()
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)GetParent();
	pDlg->invokeNome(NOME_NEXT);
	m_TitleTip.SetEnabled(true); 
	// TODO: Add your control notification handler code here
}

void CReplacement::initTab()
{
	
}
void CReplacement::OnBnClickedBadd()
{
	// TODO: Add your control notification handler code here
	CNomeTabDlg* pDlg = (CNomeTabDlg*)GetParent();
	pDlg->invokeNome(NOME_ADD);
	pDlg->m_Replacement.m_Grid.RedrawColumn(3);  
	m_TitleTip.SetEnabled(true); 
}
void CReplacement::OnBnClickedBdock()
{
	// TODO: Add your control notification handler code here
	CNomeTabDlg* pDlg = (CNomeTabDlg*)GetParent();
	pDlg->invokeNome(NOME_DOCK);
	m_TitleTip.SetEnabled(true); 
}
void CReplacement::changeLang(int lang)
{
	TCHAR buffer[1000];
	HINSTANCE hInstance = (HINSTANCE) GetModuleHandle ("nome.dll");
	LoadString(hInstance, IDS_REPLACEMENT_EN + lang, buffer, 1000);
	SetWindowText(buffer);
	m_Grid.SetItemText(0,4,buffer);
	LoadString(hInstance, IDS_OCCS_EN + lang, buffer, 1000);
	m_Grid.SetItemText(0,0,buffer);
	LoadString(hInstance, IDS_WORDS_EN + lang, buffer, 1000);
	m_Grid.SetItemText(0,3,buffer); 
	this->lang = lang;
}
void CReplacement::OnBnClickedBconflict()
{
	// TODO: Add your control notification handler code here
	CNomeTabDlg* pDlg = (CNomeTabDlg*)GetParent();
	if (pDlg->m_Replacement.updateSameReplacement()){
		TCHAR buffer[1000];
		HINSTANCE hInstance = (HINSTANCE) GetModuleHandle ("nome.dll");
		LoadString(hInstance, IDS_WARNING_CONFLICT_EN + pDlg->lang, buffer, 1000);
		MessageBox(buffer, "NOME");
	}
}

void CReplacement::OnBnClickedBremovem()
{
	// TODO: Add your control notification handler code here
	CNomeTabDlg* pDlg = (CNomeTabDlg*)GetParent();
	pDlg->invokeNome(NOME_REMOVEM);
	m_TitleTip.SetEnabled(true); 
}

void CReplacement::OnBnClickedAcceptm()
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)GetParent();
	pDlg->invokeNome(NOME_ACCEPTM);
	m_TitleTip.SetEnabled(true); 
	// TODO: Add your control notification handler code here
}

BOOL CReplacement::OnNBTooltip(UINT id, NMHDR *pNotifyStruct, LRESULT* pResult)
{
	NB_TOOLTIP* hdr = (NB_TOOLTIP*)pNotifyStruct;
	TCHAR buffer[1000];
	LoadString(AfxGetResourceHandle() , hdr->id + lang, buffer, 1000);
	// TODO: Add your message handler code here and/or call default	
    CRect rect;
	GetDlgItem(hdr->hdr.idFrom)->GetWindowRect(rect);	
	ScreenToClient(rect);
	RECT hoverRect;
	hoverRect.left = rect.left ;
	hoverRect.top= rect.top ;
	hoverRect.bottom = rect.bottom;
	hoverRect.right= rect.right;

	int h = rect.Height();
	rect.top +=  h;
	rect.bottom += h;
	m_TitleTip.Show(rect, buffer, 0, &hoverRect);
	return true;
}

void CReplacement::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	CTabDlg::OnLButtonDown(nFlags, point);
}
